from fastapi import FastAPI, UploadFile, HTTPException, Form, File
from typing import Dict, Any
import json
import chardet

app = FastAPI()


def find_and_replace_recursive(data: Any, replacements: Dict[str, str]) -> Any:
    if isinstance(data, dict):
        for key, value in data.items():
            data[key] = find_and_replace_recursive(value, replacements)
    elif isinstance(data, list):
        for i, item in enumerate(data):
            data[i] = find_and_replace_recursive(item, replacements)
    elif isinstance(data, str):
        for old_text, new_text in replacements.items():
            data = data.replace(old_text, new_text)
    return data


@app.post("/replace_values")
async def replace_values(file: UploadFile = UploadFile(...)):
    try:
        content = await file.read()
        encoding_result = chardet.detect(content)
        file_encoding = encoding_result['encoding']
        json_data = json.loads(content.decode(file_encoding))

        replacements = {
            "Value is Out of Spec": "Out of Spec",
            "Please Enter Recheck Value": "Enter Recheck Value",
            "Please Enter Comment": "Enter Comment",
            "Please Enter Value": "Enter Value",
            "AssociateAssetResource": "OplAssociateAssetResource",
            "text-center not-required w-200px": "text-center not-required"
        }

        updated_json = find_and_replace_recursive(json_data, replacements)
        add_component = []
        if add_component:
            components = add_component + updated_json["components"]
            updated_json["components"] = components
        return updated_json
    except json.JSONDecodeError:
        raise HTTPException(status_code=400, detail="Invalid JSON format in the uploaded file.")
